/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.ModConfiguration;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureAlternateStart;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiStartHouseChooser
extends GuiStructure {
    protected ModConfiguration serverConfiguration;
    private GuiButtonExt btnHouseStyle;
    private GuiButtonExt btnGlassColor;
    private GuiButtonExt btnBedColor;
    private GuiCheckBox btnAddChest;
    private GuiCheckBox btnAddChestContents;
    private GuiCheckBox btnAddMineShaft;
    private boolean allowItemsInChestAndFurnace = true;
    private HouseConfiguration configuration;

    public GuiStartHouseChooser() {
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.StartHouse;
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 212;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
        this.serverConfiguration = Prefab.proxy.getServerConfiguration();
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Starter House", HouseConfiguration.class);
        this.configuration.pos = this.pos;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnHouseStyle = this.createAndAddButton(4, grayBoxX + 15, grayBoxY + 30, 90, 20, this.configuration.houseStyle.getDisplayName(), false);
        this.btnBedColor = this.createAndAddDyeButton(5, grayBoxX + 15, grayBoxY + 65, 90, 20, this.configuration.bedColor);
        this.btnGlassColor = this.createAndAddFullDyeButton(6, grayBoxX + 15, grayBoxY + 100, 90, 20, this.configuration.glassColor);
        this.btnAddChest = this.createAndAddCheckBox(7, grayBoxX + 15, grayBoxY + 125, "prefab.gui.starter.addchest", this.configuration.addChest);
        this.btnAddMineShaft = this.createAndAddCheckBox(9, grayBoxX + 15, grayBoxY + 140, "prefab.gui.starter.buildmineshaft", this.configuration.addChestContents);
        this.btnAddChestContents = this.createAndAddCheckBox(8, grayBoxX + 15, grayBoxY + 155, "prefab.gui.starter.addchestcontents", this.configuration.addMineShaft);
        this.btnVisualize = this.createAndAddCustomButton(3, grayBoxX + 25, grayBoxY + 175, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(1, grayBoxX + 310, grayBoxY + 175, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(2, grayBoxX + 150, grayBoxY + 175, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 132;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.func_146276_q_();
        this.drawControlLeftPanel(x + 10, y + 10, 125, 190);
        this.drawControlRightPanel(imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindTexture(this.configuration.houseStyle.getHousePicture());
        Gui.func_152125_a((int)imageLocation, (int)(y + 15), (float)0.0f, (float)0.0f, (int)this.shownImageWidth, (int)this.shownImageHeight, (int)this.shownImageWidth, (int)this.shownImageHeight, (float)this.shownImageWidth, (float)this.shownImageHeight);
        this.btnAddChest.field_146125_m = this.serverConfiguration.addChests;
        this.btnAddChestContents.field_146125_m = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
        this.btnAddMineShaft.field_146125_m = this.serverConfiguration.addMineshaft;
    }

    @Override
    protected void postButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(GuiLangKeys.translateString("prefab.gui.starter.style.label"), x + 15, y + 20, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 15, y + 55, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.structure.glass"), x + 15, y + 90, this.textColor);
    }

    public void func_146284_a(GuiButton button) throws IOException {
        this.configuration.addBed = this.serverConfiguration.addBed;
        this.configuration.addChest = this.serverConfiguration.addChests && this.btnAddChest.isChecked();
        this.configuration.addChestContents = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents && this.btnAddChestContents.isChecked();
        this.configuration.addCraftingTable = this.serverConfiguration.addCraftingTable;
        this.configuration.addFurnace = this.serverConfiguration.addFurnace;
        this.configuration.addMineShaft = this.serverConfiguration.addMineshaft && this.btnAddMineShaft.isChecked();
        this.configuration.addTorches = this.serverConfiguration.addTorches;
        this.configuration.houseFacing = this.getMinecraft().field_71439_g.func_174811_aO().func_176734_d();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.configuration.houseStyle.getValue() + 1;
            this.configuration.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            if (this.configuration.houseStyle == HouseConfiguration.HouseStyle.LOFT && !this.serverConfiguration.enableLoftHouse) {
                id = this.configuration.houseStyle.getValue() + 1;
                this.configuration.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            }
            GuiUtils.setButtonText((GuiButton)this.btnHouseStyle, this.configuration.houseStyle.getDisplayName());
        } else if (button == this.btnGlassColor) {
            this.configuration.glassColor = FullDyeColor.ById(this.configuration.glassColor.getId() + 1);
            GuiUtils.setButtonText((GuiButton)this.btnGlassColor, GuiLangKeys.translateFullDye(this.configuration.glassColor));
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = EnumDyeColor.func_176764_b((int)(this.configuration.bedColor.func_176765_a() + 1));
            GuiUtils.setButtonText((GuiButton)this.btnBedColor, GuiLangKeys.translateDye(this.configuration.bedColor));
        } else if (button == this.btnVisualize) {
            StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(this.configuration.houseStyle.getStructureLocation(), StructureAlternateStart.class);
            this.performPreview(structure, this.configuration);
        }
    }
}

